<?php
declare(strict_types=1);

require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/acl.php';

function render_header(array $config, string $title = ''): void {
  start_session($config);

  $appName = (string)($config['app']['name'] ?? 'DMS');
  $role = (string)($_SESSION['user_role'] ?? 'viewer');
  $user = (string)($_SESSION['user_name'] ?? 'Utilizador');

  $pageTitle = $title ? ($title . ' - ' . $appName) : $appName;

  echo '<!doctype html><html lang="pt"><head>';
  echo '<meta charset="utf-8">';
  echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
  echo '<title>'.e($pageTitle).'</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />';
  echo '<link rel="stylesheet" href="css.css">';
  echo '<link rel="icon" type="image/x-icon" href="/blockspark_favicon.ico">';
  echo '
<style>
.toast-container{position:fixed;top:14px;left:14px;z-index:99999;display:flex;flex-direction:column;gap:10px}
.toast{min-width:260px;max-width:420px;padding:12px 14px;border-radius:14px;backdrop-filter:blur(14px);border:1px solid rgba(255,255,255,.18);box-shadow:0 10px 24px rgba(0,0,0,.18);font-size:13px}
.toast.success{background:rgba(16,185,129,.18)}
.toast.error{background:rgba(239,68,68,.18)}
.toast.info{background:rgba(59,130,246,.18)}
.icon-btn{display:inline-flex;align-items:center;justify-content:center;gap:8px;border-radius:12px;padding:10px 12px;border:1px solid rgba(255,255,255,.15);background:rgba(255,255,255,.06);color:inherit;text-decoration:none;cursor:pointer}
.icon-btn:hover{background:rgba(255,255,255,.10)}
.icon-only{width:40px;height:40px;padding:0}
.table-actions{display:flex;gap:8px;align-items:center}
.select2-container .select2-selection--single{height:42px;border-radius:12px;border:1px solid rgba(0,0,0,.12)}
.select2-container--default .select2-selection--single .select2-selection__rendered{line-height:40px;padding-left:12px}
.select2-container--default .select2-selection--single .select2-selection__arrow{height:40px}
</style>
</head>
<body>';

  echo '<div class="app-header">';
  echo '  <div class="brand">';
  echo '    <img src="assets/blockspark_symbol_transparent.png" alt="BlockSpark Automotive" class="brand-logo">';
  echo '    <div class="brand-text">';
  echo '      <div class="brand-name">BlockSpark Automotive</div>';
  echo '      <div class="brand-sub">'.e($user).' · '.e($role).'</div>';
  echo '    </div>';
  echo '  </div>';

  echo '  <div class="nav">';

  if (can_access($role,'dashboard')) echo '<a href="dashboard.php">Dashboard</a>';
  if (can_access($role,'vehicles'))  echo '<a href="vehicles.php">Viaturas</a>';
  if (can_access($role,'customers')) echo '<a href="customers.php">Clientes</a>';
  if (can_access($role,'leads'))     echo '<a href="leads.php">Leads</a>';
  if (can_access($role,'sales'))     echo '<a href="sales.php">Vendas</a>';
  if (can_access($role,'suppliers')) echo '<a href="suppliers.php">Fornecedores</a>';
  if (function_exists('has_perm') && has_perm('users')) echo '<a href="users.php">Utilizadores</a>';
  if (role_rank($role) >= 60) echo '<a href="report_monthly.php">Relatório PDF</a>';

  echo '<a href="logout.php">Sair</a>';
  echo '  </div>';
  echo '</div>';

  echo '<div class="app-container">';
}

function render_footer(): void {
  echo '</div>
<script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
function toast(type,msg){
  const c=document.getElementById('toast-container');
  if(!c) return;
  const d=document.createElement('div');
  d.className='toast '+(type||'info');
  d.textContent=msg;
  c.appendChild(d);
  setTimeout(()=>{ d.style.opacity='0'; d.style.transform='translateY(-6px)'; d.style.transition='all .25s ease'; }, 1600);
  setTimeout(()=>{ d.remove(); }, 2000);
}
$(function(){
  $('select').each(function(){
    const $s=$(this);
    if($s.data('no-select2')) return;
    $s.select2({ width:'100%' });
  });
});
</script>
<?php if (function_exists('flash_get')) { $f = flash_get(); if ($f) { ?>
<script>toast(<?= json_encode($f['type']) ?>, <?= json_encode($f['message']) ?>);</script>
<?php }} ?>
</body>
</html>';
}
