<?php
declare(strict_types=1);

$config = require __DIR__ . '/app/config.php';
require __DIR__ . '/app/db.php';
require __DIR__ . '/app/auth.php';
require __DIR__ . '/app/helpers.php';
require __DIR__ . '/app/acl.php';
require __DIR__ . '/app/layout.php';

require_login($config);
require_perm(['users']);

$id = (int)($_GET['id'] ?? 0);
$editing = $id > 0;

$user = null;
if ($editing) {
  $st = $pdo->prepare("SELECT * FROM users WHERE id=?");
  $st->execute([$id]);
  $user = $st->fetch();
  if (!$user) { http_response_code(404); exit('Utilizador não encontrado'); }
}

$perms = $pdo->query("SELECT * FROM permissions ORDER BY label")->fetchAll();
$selPerms = [];
if ($editing) {
  $st = $pdo->prepare("SELECT p.perm_key FROM user_permissions up JOIN permissions p ON p.id=up.permission_id WHERE up.user_id=?");
  $st->execute([$id]);
  foreach ($st->fetchAll() as $r) $selPerms[(string)$r['perm_key']] = true;
}

$roles = ['admin','manager','finance','sales','ops','viewer'];

$generatedPassword = null;

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  try {
    $email = trim((string)($_POST['email'] ?? ''));
    $role  = trim((string)($_POST['role'] ?? 'viewer'));
    $isActive = (int)($_POST['is_active'] ?? 1) ? 1 : 0;
    $permKeys = $_POST['perms'] ?? [];

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) throw new RuntimeException('Email inválido.');
    if (!in_array($role, $roles, true)) $role = 'viewer';

    if ($editing) {
      $pdo->prepare("UPDATE users SET email=?, role=?, is_active=? WHERE id=?")->execute([$email,$role,$isActive,$id]);
      $newPass = (string)($_POST['new_password'] ?? '');
      if ($newPass !== '') {
        $hash = password_hash($newPass, PASSWORD_DEFAULT);
        $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([$hash,$id]);
      }
    } else {
      $newPass = (string)($_POST['new_password'] ?? '');
      if ($newPass === '') {
        $newPass = bin2hex(random_bytes(4)).'A!';
        $generatedPassword = $newPass;
      }
      $hash = password_hash($newPass, PASSWORD_DEFAULT);
      $pdo->prepare("INSERT INTO users (email,password_hash,role,is_active,created_at) VALUES (?,?,?,?,NOW())")
          ->execute([$email,$hash,$role,1]);
      $id = (int)$pdo->lastInsertId();
      $editing = true;
    }

    $pdo->prepare("DELETE FROM user_permissions WHERE user_id=?")->execute([$id]);
    if (is_array($permKeys)) {
      $map = [];
      foreach ($perms as $p) $map[$p['perm_key']] = (int)$p['id'];
      $ins = $pdo->prepare("INSERT INTO user_permissions (user_id,permission_id) VALUES (?,?)");
      foreach ($permKeys as $k) {
        $k = (string)$k;
        if (isset($map[$k])) $ins->execute([$id, $map[$k]]);
      }
    }

    flash_set('success', 'Utilizador guardado.');
    header("Location: user_edit.php?id=".$id);
    exit;

  } catch (Throwable $e) {
    flash_set('error', $e->getMessage());
  }
}

render_header($config, $editing ? 'Editar utilizador' : 'Novo utilizador');
?>
<div class="card">
  <div style="display:flex;justify-content:space-between;align-items:center;gap:12px">
    <h1 style="margin:0"><?= $editing ? 'Editar utilizador' : 'Novo utilizador' ?></h1>
    <a class="icon-btn icon-only" href="users.php" title="Voltar"><i class="fa-solid fa-arrow-left"></i></a>
  </div>

  <?php if ($generatedPassword): ?>
    <div class="card" style="border-left:6px solid #1f7a1f">
      Password gerada: <b><?= e($generatedPassword) ?></b> (guarda agora)
    </div>
  <?php endif; ?>

  <form method="post" class="row" style="flex-wrap:wrap;gap:12px">
    <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">

    <div style="flex:2;min-width:280px">
      <label>Email</label>
      <input name="email" value="<?= e((string)($user['email'] ?? '')) ?>" required>
    </div>

    <div style="flex:1;min-width:180px">
      <label>Role</label>
      <select name="role">
        <?php foreach ($roles as $rr): ?>
          <option value="<?= e($rr) ?>" <?= (($user['role'] ?? 'viewer')===$rr?'selected':'') ?>><?= e($rr) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div style="flex:1;min-width:160px">
      <label>Ativo</label>
      <select name="is_active">
        <option value="1" <?= ((int)($user['is_active'] ?? 1)===1?'selected':'') ?>>Sim</option>
        <option value="0" <?= ((int)($user['is_active'] ?? 1)===0?'selected':'') ?>>Não</option>
      </select>
    </div>

    <div style="flex:1;min-width:220px">
      <label><?= $editing ? 'Nova password (opcional)' : 'Password (vazio = gerar)' ?></label>
      <input name="new_password" autocomplete="new-password">
    </div>

    <div style="flex:1;min-width:260px">
      <label>Permissões (módulos)</label>
      <select name="perms[]" multiple data-no-select2="1" style="height:160px">
        <?php foreach ($perms as $p): $k=(string)$p['perm_key']; ?>
          <option value="<?= e($k) ?>" <?= !empty($selPerms[$k]) ? 'selected' : '' ?>><?= e($p['label']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div style="align-self:end;display:flex;gap:10px">
      <button class="icon-btn" type="submit" title="Guardar"><i class="fa-solid fa-floppy-disk"></i> Guardar</button>
    </div>
  </form>
</div>
<?php render_footer(); ?>
