<?php
declare(strict_types=1);

$config = require __DIR__ . '/app/config.php';
require __DIR__ . '/app/db.php';
require __DIR__ . '/app/auth.php';
require __DIR__ . '/app/helpers.php';
require __DIR__ . '/app/acl.php';
require __DIR__ . '/app/layout.php';

require_login($config);
require_perm(['users']);

$rows = $pdo->query("SELECT id,email,role,is_active,created_at FROM users ORDER BY id DESC")->fetchAll();

render_header($config, 'Utilizadores');
?>
<div class="card">
  <div style="display:flex;justify-content:space-between;align-items:center;gap:12px">
    <h1 style="margin:0">Utilizadores</h1>
    <a class="icon-btn icon-only" href="user_edit.php" title="Novo"><i class="fa-solid fa-plus"></i></a>
  </div>

  <table>
    <thead><tr><th>ID</th><th>Email</th><th>Role</th><th>Ativo</th><th>Criado</th><th>Abrir</th></tr></thead>
    <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><?= (int)$r['id'] ?></td>
          <td><?= e($r['email']) ?></td>
          <td><span class="badge"><?= e($r['role']) ?></span></td>
          <td><?= ((int)$r['is_active']===1) ? '<span class="badge roi-green">sim</span>' : '<span class="badge roi-red">não</span>' ?></td>
          <td><?= e((string)$r['created_at']) ?></td>
          <td class="table-actions">
            <a class="icon-btn icon-only" href="user_edit.php?id=<?= (int)$r['id'] ?>" title="Editar"><i class="fa-solid fa-pen"></i></a>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (count($rows)===0): ?><tr><td colspan="6" style="color:#6b7280">Sem utilizadores.</td></tr><?php endif; ?>
    </tbody>
  </table>
</div>
<?php render_footer(); ?>
