<?php
declare(strict_types=1);

function role_rank(string $role): int {
  return match($role) {
    'admin'   => 100,
    'manager' => 80,
    'finance' => 60,
    'sales'   => 50,
    'ops'     => 40,
    'viewer'  => 10,
    default   => 0
  };
}

function require_role(array $config, array $rolesAllowed): void {
  start_session($config);
  $role = (string)($_SESSION['user_role'] ?? 'viewer');
  if (in_array($role, $rolesAllowed, true)) return;
  http_response_code(403);
  exit('Acesso negado.');
}

function can_access(string $role, string $area): bool {
  return match($area) {
    'dashboard' => role_rank($role) >= 10,
    'vehicles'  => role_rank($role) >= 40,
    'customers' => role_rank($role) >= 50,
    'leads'     => role_rank($role) >= 50,
    'sales'     => role_rank($role) >= 50,
    'suppliers' => role_rank($role) >= 40,
    'finance'   => role_rank($role) >= 60,
    'admin'     => role_rank($role) >= 100,
    default     => false
  };
}
