<?php
declare(strict_types=1);

function e(?string $v): string {
  return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}

function money($v): string {
  if ($v === null || $v === '') return '—';
  return number_format((float)$v, 2, ',', '.') . ' €';
}

function now_date(): string {
  return date('Y-m-d');
}

function days_between(?string $from, ?string $to = null): ?int {
  if (!$from) return null;
  $d1 = new DateTime($from);
  $d2 = new DateTime($to ?? date('Y-m-d'));
  return (int)$d1->diff($d2)->format('%a');
}

function csrf_token(): string {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  if (empty($_SESSION['_csrf'])) $_SESSION['_csrf'] = bin2hex(random_bytes(16));
  return $_SESSION['_csrf'];
}

function csrf_check(): void {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  $t = $_POST['_csrf'] ?? '';
  if (!$t || empty($_SESSION['_csrf']) || !hash_equals($_SESSION['_csrf'], (string)$t)) {
    http_response_code(403);
    exit('CSRF invalid');
  }
}



function generate_next_code(PDO $pdo, string $table, string $column, string $prefix, int $pad = 4): string {
  if (!preg_match('/^[a-zA-Z0-9_]+$/', $table) || !preg_match('/^[a-zA-Z0-9_]+$/', $column)) {
    throw new RuntimeException('Tabela/coluna inválida para geração de código.');
  }
  $prefixLen = strlen($prefix);
  $sql = "SELECT MAX(CAST(SUBSTRING($column, " . ($prefixLen+1) . ") AS UNSIGNED)) AS mx
          FROM $table WHERE $column LIKE ?";
  $st = $pdo->prepare($sql);
  $st->execute([$prefix . '%']);
  $mx = (int)($st->fetchColumn() ?: 0);
  $next = $mx + 1;
  return $prefix . str_pad((string)$next, $pad, '0', STR_PAD_LEFT);
}

function ensure_customer_code(PDO $pdo, int $customerId): void {
  $st = $pdo->prepare("SELECT customer_code FROM customers WHERE id=?");
  $st->execute([$customerId]);
  $code = (string)($st->fetchColumn() ?? '');
  if ($code !== '') return;
  $new = generate_next_code($pdo, 'customers', 'customer_code', 'C', 5);
  $up = $pdo->prepare("UPDATE customers SET customer_code=? WHERE id=?");
  $up->execute([$new, $customerId]);
}

