<?php
declare(strict_types=1);

$config = require __DIR__ . '/app/config.php';
require __DIR__ . '/app/db.php';
require __DIR__ . '/app/auth.php';
require __DIR__ . '/app/helpers.php';
require __DIR__ . '/app/acl.php';
require __DIR__ . '/app/layout.php';

require_login($config);
require_role($config, ['admin','manager','finance','sales']);

$rows = $pdo->query("SELECT * FROM customers ORDER BY created_at DESC LIMIT 300")->fetchAll();

render_header($config, 'Clientes');
?>
  <div class="card">
    <div style="display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap">
      <h1 style="margin:0">Clientes</h1>
      <a class="btn" href="customer_edit.php">+ Novo cliente</a>
    </div>
    <table>
      <thead><tr><th>Código</th><th>Tipo</th><th>Nome</th><th>NIF</th><th>Morada</th><th>Telefone</th><th>Email</th><th>Abrir</th></tr></thead>
      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><?= e((string)($r['customer_code'] ?? '')) ?></td><td><?= e($r['type']) ?></td><td><?= e($r['name']) ?></td><td><?= e((string)$r['nif']) ?></td><td><?= e((string)$r['address']) ?></td><td><?= e((string)$r['phone']) ?></td><td><?= e((string)$r['email']) ?></td><td><a href="customer_edit.php?id=<?= (int)$r['id'] ?>">Ver</a></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
<?php render_footer(); ?>
