<?php
declare(strict_types=1);

$config = require __DIR__ . '/app/config.php';
require __DIR__ . '/app/db.php';
require __DIR__ . '/app/auth.php';
require __DIR__ . '/app/helpers.php';

start_session($config);
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = trim($_POST['email'] ?? '');
  $pass  = (string)($_POST['password'] ?? '');

  $stmt = $pdo->prepare("SELECT id,name,email,password_hash,role,is_active FROM users WHERE email=?");
  $stmt->execute([$email]);
  $u = $stmt->fetch();

  if ($u && (int)$u['is_active'] === 1 && password_verify($pass, $u['password_hash'])) {
    login_user($config, (int)$u['id'], (string)$u['name'], (string)$u['role']);
    header('Location: dashboard.php');
    exit;
  }
  $error = 'Login inválido.';
}
?>
<!doctype html>
<html lang="pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login</title>
  <link rel="icon" href="/blockspark_favicon.ico">
  <style>
    :root{
      --bg1:#eef2f7; --bg2:#dfe6f1;
      --card:rgba(255,255,255,.72);
      --border:rgba(15,23,42,.10);
      --text:#0b3a68;
      --muted:#6b7280;
      --input:#ffffffb0;
      --shadow: 0 22px 60px rgba(0,0,0,.10);
      --btn:#0b3a68;
    }
    @media (prefers-color-scheme: dark){
      :root{
        --bg1:#0b1220; --bg2:#050914;
        --card:rgba(17,25,40,.62);
        --border:rgba(255,255,255,.10);
        --text:#e5e7eb;
        --muted:#9ca3af;
        --input:rgba(255,255,255,.08);
        --shadow: 0 24px 70px rgba(0,0,0,.45);
        --btn:#1d4ed8;
      }
    }

    body{
      margin:0; height:100vh;
      display:flex; align-items:center; justify-content:center;
      background: radial-gradient(1200px 600px at 20% 20%, rgba(255,255,255,.35), transparent 60%),
                  radial-gradient(900px 500px at 80% 30%, rgba(255,200,80,.20), transparent 60%),
                  linear-gradient(135deg,var(--bg1),var(--bg2));
      font-family: Arial, sans-serif;
      color:var(--text);
    }

    .wrap{ width:100%; max-width:520px; padding:22px; }
    .logo{
      display:flex; justify-content:center; margin-bottom:22px;
      animation: floaty 4.5s ease-in-out infinite;
      transform-origin:center;
    }
    .logo img{
      width:330px; height:auto;
      filter: drop-shadow(0 18px 26px rgba(0,0,0,.18));
    }
    @media (prefers-color-scheme: dark){
      .logo img{
        filter: drop-shadow(0 20px 28px rgba(0,0,0,.55)) brightness(1.15) contrast(1.05);
      }
    }

    @keyframes floaty{
      0%,100%{ transform: translateY(0) }
      50%{ transform: translateY(-8px) }
    }

    .card{
      background:var(--card);
      border:1px solid var(--border);
      border-radius:18px;
      padding:26px;
      box-shadow: var(--shadow);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      position:relative;
      overflow:hidden;
    }
    .card:before{
      content:"";
      position:absolute; inset:-2px;
      background: linear-gradient(120deg, transparent 0%, rgba(255,255,255,.25) 40%, transparent 70%);
      transform: translateX(-80%);
      animation: sheen 7s ease-in-out infinite;
      pointer-events:none;
    }
    @keyframes sheen{
      0%,40%{ transform: translateX(-90%) }
      60%,100%{ transform: translateX(90%) }
    }

    label{ font-weight:700; font-size:13px; color:var(--muted); }
    input{
      width:100%;
      padding:12px 12px;
      border-radius:12px;
      border:1px solid var(--border);
      background:var(--input);
      color:var(--text);
      margin:6px 0 14px 0;
      outline:none;
    }
    input:focus{ box-shadow:0 0 0 4px rgba(29,78,216,.18); border-color:rgba(29,78,216,.55); }

    button{
      width:100%;
      padding:12px;
      border:0;
      border-radius:12px;
      background:var(--btn);
      color:#fff;
      font-weight:900;
      cursor:pointer;
    }
    button:hover{ filter:brightness(1.03); }
    .error{ color:#ff6b6b; font-weight:800; margin:0 0 12px 0; }
    .hint{ margin-top:12px; color:var(--muted); font-size:12px; text-align:center }
  </style>
</head>
<body>
  <div class="wrap">
    <div class="logo">
      <img src="assets/blockspark_logo_transparent.png" alt="BlockSpark">
    </div>

    <form method="post" class="card">
      <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">

      <?php if ($error): ?><div class="error"><?= e($error) ?></div><?php endif; ?>

      <label>Email</label>
      <input name="email" type="email" required>

      <label>Password</label>
      <input name="password" type="password" required>

      <button type="submit">Entrar</button>
    </form>

    <div class="hint">© BlockSpark Automotive</div>
  </div>
</body>
</html>
