-- V8 Migration: lead stage events + reports helpers
CREATE TABLE IF NOT EXISTS lead_stage_events (
  id INT AUTO_INCREMENT PRIMARY KEY,
  lead_id INT NOT NULL,
  from_stage ENUM('novo','contactado','test_drive','proposta','financiamento','fechado','perdido') NULL,
  to_stage   ENUM('novo','contactado','test_drive','proposta','financiamento','fechado','perdido') NOT NULL,
  changed_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  changed_by INT NULL,
  notes VARCHAR(255) NULL,
  INDEX idx_lse_lead (lead_id),
  INDEX idx_lse_changed_at (changed_at),
  CONSTRAINT fk_lse_lead FOREIGN KEY (lead_id) REFERENCES leads(id) ON DELETE CASCADE,
  CONSTRAINT fk_lse_user FOREIGN KEY (changed_by) REFERENCES users(id) ON DELETE SET NULL
);
