<?php
declare(strict_types=1);

$config = require __DIR__ . '/app/config.php';
require __DIR__ . '/app/db.php';
require __DIR__ . '/app/auth.php';
require __DIR__ . '/app/helpers.php';
require __DIR__ . '/app/acl.php';
require __DIR__ . '/app/layout.php';

require_login($config);
require_role($config, ['admin','manager','finance','ops','sales']);

$rows = $pdo->query("SELECT * FROM suppliers ORDER BY is_active DESC, name ASC")->fetchAll();

render_header($config, 'Fornecedores');
?>
<div class="card">
  <div style="display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap">
    <h1 style="margin:0">Fornecedores</h1>
    <a class="btn" href="supplier_edit.php">+ Novo fornecedor</a>
  </div>

  <table>
    <thead><tr><th>Nome</th><th>NIF</th><th>Telefone</th><th>Email</th><th>Ativo</th><th>Abrir</th></tr></thead>
    <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><?= e($r['name']) ?></td>
          <td><?= e((string)$r['nif']) ?></td>
          <td><?= e((string)$r['phone']) ?></td>
          <td><?= e((string)$r['email']) ?></td>
          <td><?= ((int)$r['is_active']===1) ? '<span class="badge roi-green">Sim</span>' : '<span class="badge roi-red">Não</span>' ?></td>
          <td><a href="supplier_edit.php?id=<?= (int)$r['id'] ?>">Ver</a></td>
        </tr>
      <?php endforeach; ?>
      <?php if (count($rows)===0): ?>
        <tr><td colspan="6" style="color:#6b7280">Sem fornecedores.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
<?php render_footer(); ?>
