<?php
declare(strict_types=1);

require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/acl.php';

function render_header(array $config, string $title = ''): void {
  start_session($config);

  $appName = (string)($config['app']['name'] ?? 'DMS');
  $role = (string)($_SESSION['user_role'] ?? 'viewer');
  $user = (string)($_SESSION['user_name'] ?? 'Utilizador');

  $pageTitle = $title ? ($title . ' - ' . $appName) : $appName;

  echo '<!doctype html><html lang="pt"><head>';
  echo '<meta charset="utf-8">';
  echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
  echo '<title>'.e($pageTitle).'</title>';
  echo '<link rel="stylesheet" href="css.css">';
  echo '<link rel="icon" type="image/x-icon" href="/blockspark_favicon.ico">';
  echo '</head><body>';

  echo '<div class="app-header">';
  echo '  <div class="brand">';
  echo '    <img src="assets/blockspark_symbol_transparent.png" alt="BlockSpark Automotive" class="brand-logo">';
  echo '    <div class="brand-text">';
  echo '      <div class="brand-name">BlockSpark Automotive</div>';
  echo '      <div class="brand-sub">'.e($user).' · '.e($role).'</div>';
  echo '    </div>';
  echo '  </div>';

  echo '  <div class="nav">';

  if (can_access($role,'dashboard')) echo '<a href="dashboard.php">Dashboard</a>';
  if (can_access($role,'vehicles'))  echo '<a href="vehicles.php">Viaturas</a>';
  if (can_access($role,'customers')) echo '<a href="customers.php">Clientes</a>';
  if (can_access($role,'leads'))     echo '<a href="leads.php">Leads</a>';
  if (can_access($role,'sales'))     echo '<a href="sales.php">Vendas</a>';
  if (role_rank($role) >= 60) echo '<a href="report_monthly.php">Relatório PDF</a>';

  echo '<a href="logout.php">Sair</a>';
  echo '  </div>';
  echo '</div>';

  echo '<div class="app-container">';
}

function render_footer(): void {
  echo '</div></body></html>';
}
