<?php
declare(strict_types=1);

$config = require __DIR__ . '/app/config.php';
require __DIR__ . '/app/db.php';
require __DIR__ . '/app/auth.php';
require __DIR__ . '/app/helpers.php';
require __DIR__ . '/app/acl.php';
require __DIR__ . '/app/layout.php';

require_login($config);
require_role($config, ['admin','manager','finance','sales']);

$rows = $pdo->query("SELECT * FROM customers ORDER BY created_at DESC LIMIT 300")->fetchAll();

render_header($config, 'Clientes');
?>
  <div class="card">
    <h1 style="margin-top:0">Clientes</h1>
    <table>
      <thead><tr><th>Tipo</th><th>Nome</th><th>NIF</th><th>Telefone</th><th>Email</th></tr></thead>
      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><?= e($r['type']) ?></td><td><?= e($r['name']) ?></td><td><?= e((string)$r['nif']) ?></td><td><?= e((string)$r['phone']) ?></td><td><?= e((string)$r['email']) ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
<?php render_footer(); ?>
