<?php
declare(strict_types=1);

$config = require __DIR__ . '/app/config.php';
require __DIR__ . '/app/db.php';
require __DIR__ . '/app/auth.php';
require __DIR__ . '/app/helpers.php';
require __DIR__ . '/app/acl.php';
require __DIR__ . '/app/layout.php';

require_login($config);
require_role($config, ['admin','manager','finance','sales','ops']);

$rows = $pdo->query("SELECT * FROM vehicles ORDER BY entry_date DESC, id DESC LIMIT 300")->fetchAll();

render_header($config, 'Viaturas');
?>
  <div class="card">
    <h1 style="margin-top:0">Viaturas</h1>
    <table>
      <thead><tr><th>Código</th><th>Viatura</th><th>Matrícula</th><th>Estado</th><th>Entrada</th><th>Abrir</th></tr></thead>
      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><?= e($r['internal_code']) ?></td><td><?= e(trim($r['brand'].' '.$r['model'].' '.$r['version'])) ?></td><td><?= e((string)$r['plate']) ?></td><td><?= '<span class="badge">'.e($r['status']).'</span>' ?></td><td><?= e((string)$r['entry_date']) ?></td><td><?= '<a href="vehicle_view.php?id='.(int)$r['id'].'">Ver</a>' ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
<?php render_footer(); ?>
